import pygame
import sys

# Pygame setup
pygame.init()
screen_width = 800
screen_height = 600
screen = pygame.display.set_mode((screen_width, screen_height))
clock = pygame.time.Clock()
running = True
dt = 0

# Player initial positions and attributes
player_radius = 20  # Radius of the player circles
player1_pos = pygame.Vector2(screen_width / 4, screen_height / 2)
player2_pos = pygame.Vector2(3 * screen_width / 4, screen_height / 2)
player1_velocity = pygame.Vector2(0, 0)
player2_velocity = pygame.Vector2(0, 0)

# Main game loop
while running:
    # Event handling
    for event in pygame.event.get():
        if event.type == pygame.QUIT:
            running = False
    
    # Player 1 controls (WASD keys)
    keys = pygame.key.get_pressed()
    if keys[pygame.K_w]:
        player1_velocity.y = -5
    elif keys[pygame.K_s]:
        player1_velocity.y = 5
    else:
        player1_velocity.y = 0
        
    if keys[pygame.K_a]:
        player1_velocity.x = -5
    elif keys[pygame.K_d]:
        player1_velocity.x = 5
    else:
        player1_velocity.x = 0
    
    # Player 2 controls (Arrow keys)
    if keys[pygame.K_UP]:
        player2_velocity.y = -5
    elif keys[pygame.K_DOWN]:
        player2_velocity.y = 5
    else:
        player2_velocity.y = 0
        
    if keys[pygame.K_LEFT]:
        player2_velocity.x = -5
    elif keys[pygame.K_RIGHT]:
        player2_velocity.x = 5
    else:
        player2_velocity.x = 0
    
    # Update player positions based on velocity
    player1_pos += player1_velocity
    player2_pos += player2_velocity
    
    # Ensure players stay within screen bounds
    player1_pos.x = max(player_radius, min(player1_pos.x, screen_width - player_radius))
    player1_pos.y = max(player_radius, min(player1_pos.y, screen_height - player_radius))
    player2_pos.x = max(player_radius, min(player2_pos.x, screen_width - player_radius))
    player2_pos.y = max(player_radius, min(player2_pos.y, screen_height - player_radius))
    
    # Check for collision between players and prevent overlap
    distance = (player1_pos - player2_pos).length()
    min_distance = 2 * player_radius
    
    if distance < min_distance:
        
        quit()
        # Calculate the direction vector between the players
        #direction = (player1_pos - player2_pos).normalize()
        
        # Calculate the distance to move each player to prevent overlap
        #move_distance = (min_distance - distance) / 2
        
        # Move players away from each other
        #player1_pos += direction * move_distance
        #player2_pos -= direction * move_distance
    
    # Clear screen with black
    screen.fill((0, 0, 0))
    
    # Draw circles for players
    pygame.draw.circle(screen, (255, 0, 0), (int(player1_pos.x), int(player1_pos.y)), player_radius)
    pygame.draw.circle(screen, (0, 0, 255), (int(player2_pos.x), int(player2_pos.y)), player_radius)
    
    # Update display
    pygame.display.flip()
    
    # Limit to 60 FPS
    dt = clock.tick(60) / 1000

# Quit pygame
pygame.quit()
sys.exit()
