'''
Conway's game of life, step 10
adding menu and functionality for loading and saving files											 
'''
import tkinter as tk
import tkinter.simpledialog as tkd
import random
import sys
import tkinter.filedialog as tkf

board_rows = [
           ".......................................................",
           "....#..................................................",
           ".....#.................................................",
           "...###.................................................",
           ".......................................................",
           ".......................................................",
           ".......................................................",
           ".......................................................",
           ".......................................................",
           ".......................................................",
           ".......................................................",
           ".......................................................",
           ".......................................................",
           ".......................................................",
           ".......................................................",
           ".......................................................",
           ".......................................................",
           ".......................................................",
           ".......................................................",
           ".......................................................",
           ".......................................................",
           ".......................................................",
           ".......................................................",
           ".......................................................",
           ".......................................................",
           ".......................................................",
           ".......................................................",
           ".......................................................",
           ".......................................................",
           ".......................................................",
           ".......................................................",
           ".......................................................",
           ".......................................................",
           ".......................................................",
           ".......................................................",
           ".......................................................",
           ".......................................................",
           ".......................................................",
           ".......................................................",
           ".......................................................",
           ".......................................................",
           ".......................................................",
           ".......................................................",
           ".......................................................",
           ".......................................................",
           ".......................................................",
           ".......................................................",
           ".......................................................",
           ".......................................................",
           ".......................................................",
           ".......................................................",
           ".......................................................",
           ".......................................................",
           ".......................................................",
           "......................................................."
       ]

def close_window(): 
    root.destroy()

def load_board(file=None):      # filename passed when reopening (resetting) same file
    global board
    global step
    global openfile
    board = []
    board, openfile = load_board_from_file(file)
    step = 1
    display_board(board)   

def load_board_from_file(filename=None):
    if filename is None:
        filename = tkf.askopenfilename(defaultextension='.gol',
                                       filetypes=(('game of life files', '*.gol'), ('All files', '*.*')))
    board_file = open(filename, 'r')
    row = board_file.readline().strip('\n')
    y = 1
    board = []
    while row != "":
        board.append(list(row))
        y += 1
        row = board_file.readline().strip('\n')
    board_file.close()
    return board, filename

def save_board_to_file(board):
    filename = tkf.asksaveasfilename(defaultextension='.gol',
                                     filetypes=(('game of life files', '*.gol'), ('All files', '*.*')))
    if filename:
        f = open(filename, 'w')
        for row in range(len(board)):
            f.write(''.join(board[row]) + '\n')
        f.close()

def makemenu(win):
    top = tk.Menu(win)        # win=top-level window
    win.config(menu=top)      # set its menu option
    filemenu = tk.Menu(top)
    filemenu.add_command(label='Open...', command=load_board, underline=0)
    filemenu.add_command(label='Save...', command=lambda: save_board_to_file(board), underline=0)
    filemenu.add_command(label='Quit', command=close_window, underline=0)
    top.add_cascade(label='File', menu=filemenu, underline=0)
    edit = tk.Menu(top, tearoff=False)
    edit.add_command(label='Clear', command=clear, underline=0)
    edit.add_command(label='Randomize', command=rand_board, underline=0)
    edit.add_separator()
    top.add_cascade(label='Edit', menu=edit, underline=0)

def create_random_board(density):
    for row in range(len(board)):
        for col in range(len(board[0])):
            r = random.randrange(100)
            if r > density:
                board[row][col] = "."
            else:
                board[row][col] = "#"

def rand_board():
    global board
    global step
    global openfile
    density = tkd.askinteger('Density', 'enter a cell density between 0 and 100')
    create_random_board(density)
    step = 1
    #openfile = 'empty_board.gol'
    display_board(board)

def clear():
    global step
    rows = len(board)
    cols = len(board[0])
    for row in range(rows):
        for col in range(cols):
            board[row][col] = "."
    step = 0
    display_board(board)

def checkpause(p=False):
    global pause
    pause = p

def switch_cell(event):           # turn cell on or off with mouse click
    global alive
    cx = event.x
    cy = event.y
    bx = cx//sz
    by = cy//sz
    if bx < len(board[0]) and by < len(board):
        if board[by][bx] == ".":
            board[by][bx] = "#"
        else:
            board[by][bx] = "."
        display_board(board)

def life(from_startbutton=False, from_stepbutton=False):
    global step
    global board
    global pause
    global alive
    step += 1
    board = lifecycle(board)
    display_board(board)         # draw board and count living cells
    if from_startbutton is True: # function has been called from start button and not from recursion (root.after...)
        pause = False            # necessary for restart the startbutton is pressed after the pauzebutton
    checkpause(pause)
    if step <= steps and not pause and not from_stepbutton:
        delay = 10
        root.after(delay, life)  # root.after(delay, life()) is WRONG:  The function life needs to be passed as argument
                                 # life() will pass the result of life, i.e. execute it, before root.mainloop()

def display_board(board):
    my_canvas.delete(tk.ALL)     # clear the canvas
    cols = len(board[0])
    rows = len(board)
    counter = 0
    for x in range(cols):
        for y in range(rows):
            rect = (x*sz, y*sz, (x+1)*sz, (y+1)*sz)
            if board[y][x] == "#":
                my_canvas.create_rectangle(rect, outline="black", fill="orange")
                counter += 1
            else:
                my_canvas.create_rectangle(rect, outline="orange")
    stats = "living cells: " + str(counter) + "\n\ngeneration: " + str(step)
    my_canvas.create_text((10, 10), text=stats, fill='white', anchor='nw', )      # show stats on canvas

def lifecycle(board_before):
    rows = len(board_before)
    cols = len(board_before[0])
    board_after = []
    for row in range(rows):         # initialize after
        board_after.append(list("."*cols))
    for row in range(rows):
        for col in range(cols):
            num_surr = count_surrounding(row, col, board_before)
            if board_before[row][col] == "#" and num_surr < 2:
                board_after[row][col] = "."
            elif board_before[row][col] == "#" and num_surr > 3:
                board_after[row][col] = "."
            elif board_before[row][col] == "." and num_surr == 3:
                board_after[row][col] = "#"
            else:
                board_after[row][col] = board_before[row][col]
    return board_after

def count_surrounding(row, col, board):
    count = 0
    rows = len(board)
    cols = len(board[0])
    for r_pos in range(row-1, row+2): #----------
        r = r_pos % rows
        for c_pos in range(col-1, col+2): #----------
            c = c_pos % cols
            if not (r == row and c == col):  #skip cell in question
                if board[r][c] == "#":
                    count += 1
    return count

def init_board(board_rows):
    new_board = []
    for row in board_rows:
        new_row = []
        for column in range(len(row)):
            #print(row[column],end="")
            new_row.append(row[column])
        #print()
        new_board.append(new_row)
    return new_board

# main program:
board = init_board(board_rows)
alive = 0                                        # for statistics
sz = 12                                          # cell size for visualization
steps = 100000                                   # run a number of steps
step = 1
pause = False                                    # is the program paused
root = tk.Tk()                                   # create a background window
root.title("Conway's Game of Life")              # set window title
makemenu(root)
right_frame = tk.Frame(root, bg='white')         # container to group elements
my_canvas = tk.Canvas(root, width=len(board[0])*sz + 1, height=len(board)*sz+1, highlightthickness=0, bd=0, bg='grey')
startbutton = tk.Button(right_frame, text='START', width=10, command=lambda: life(from_startbutton=True))
pausebutton = tk.Button(right_frame, text='PAUSE', width=10, command=lambda: checkpause(p=True))
stepbutton = tk.Button(right_frame, text='STEP', width=10, command=lambda: life(from_stepbutton=True))
clearbutton = tk.Button(right_frame, text='CLEAR', width=10, command=clear)
randombutton = tk.Button(right_frame, text='RANDOMIZE', width=10, command=rand_board)
# The Grid geometry manager puts the widgets in a 2-dimensional table.
# The master widget is split into a number of rows and columns, and each "cell" in the resulting table can hold a widget.
startbutton.grid(row=1, column=0, padx=10, pady=10)
pausebutton.grid(row=2, column=0, padx=10, pady=10)
stepbutton.grid(row=3, column=0, padx=10, pady=10)
clearbutton.grid(row=4, column=0, padx=10, pady=10)
randombutton.grid(row=8, column=0, padx=10, pady=10)
# put everything on the screen:
display_board(board)
my_canvas.bind("<Button-1>", switch_cell)        # make canvas clickable, <Button-1> is the event that occurs when the mouse button is pressed. 
right_frame.pack(side=tk.RIGHT, expand=tk.YES, fill=tk.BOTH)   # Pack geometry manager packs widgets in rows or columns
my_canvas.pack(side=tk.TOP, expand=tk.YES, fill=tk.BOTH)
root.mainloop()                                  # start tkinter event loop



