from turtle import *

setup(600, 600)
speed(0)
pixel_width = 20
tracer(1,2)

picture = ["........................",
           "....aa............aa....",
           "...axxa..........axxa...",
           "...axxxa........axxxa...",
           "...axqxxa......axxqxa...",
           "...axqqxa......axqqxa...",
           "...axqqxxaaaaaaxxqqxa...",
           "...axxxxxxbbbbxxxxxxa...",
           "...axxxxxxxbbxxxxxxxa...",
           "...axxxxxxxxxxxxxxxxa...",
           "...axxxxxxxxxxxxxxxxa...",
           "..axxxxxxxxxxxxxxxxxxa..",
           ".axxxxxxaaxxxxxaaxxxxxa.",
           "..axxxxxaaxxxxxaaxxxxa..",
           ".axxxxxxaaxxxxxaaxxxxxa.",
           "..aaxxxxxxxqqqxxxxxxaa..",
           "....abbxxxxxqxxxxbba....",
           ".....aabxxxxxxxxbaa.....",
           ".......aaaaaaaaaa.......",
           "........................"]
char_to_col = {
    "x": "#4b535e", #grau
    ".": "#ffffff", #weiß
    "q": "#f086bd", #rosa
    "a": "#212121", #schwarz
    "b": "#474747", #dunkelgrau
}

def paint_pixel(x,y,col):
    pu()
    goto(x*pixel_width, -y*pixel_width)
    pd()
    fillcolor(col)
    color(col)
    begin_fill()
    for i in range(4):
        fd(pixel_width)
        lt(90)
    end_fill()

x_s = len(picture[0]) // 2
y_s = len(picture) // 2
for y in range(len(picture)):
    for x in range(len(picture[y])):
        paint_pixel(x-x_s,y-y_s,char_to_col[picture[y][x]])
