from turtle import *
import numpy as np
from PIL import Image

tracer(0,0)
#set speed variable(1-20 recommended)
speed = 5

def resize_image(image_path, output_path):
    with Image.open(image_path) as img:
        original_size = img.size
        print(f"Original size: {original_size}")

        # Calculate the new size while preserving the aspect ratio
        img.thumbnail((40, 40))

        img.save(output_path)
        return np.array(img)

raster = resize_image("ml.jpg", "out.jpg")
raster = raster.dot(1/255)
print(raster[0][0][0])

penup()
goto(-150,200)
pendown()
pixel_size = 10
pensize(pixel_size)
for h in range(len(raster)):
    for w in range(len(raster[0])):
        color(raster[h][w][0],raster[h][w][1],raster[h][w][2])
        #square(ps)
        fd(pixel_size)
        if w % speed == 0:
            update()
    penup()
    bk(pixel_size*len(raster[0]))
    rt(90)
    fd(pixel_size)
    lt(90)
    pendown()

done()