from turtle import *

setup(600,600)
speed(10)
pixel_width = 10

picture = [".q.q.q.q",
           "qxx.qxx.",
           ".xxq.xxq",
           "q.qxx.q.",
           ".qxxxx.q",
           "q.xxxxq.",
           ".qxq.x.q",
           "q.q.q.q."]

char_to_col = {
    "x": "#0c3504",
    ".": "#238210",
    "q": "#bcddb5"
}

def paint_pixel(x,y,col):
    pu()
    goto(x*pixel_width, -y*pixel_width)
    pd()
    fillcolor(col)
    color(col)
    begin_fill()
    for i in range(4):
        fd(pixel_width)
        lt(89)
    end_fill()

x_s = len(picture[0]) // 2
y_s = len(picture) // 2
for y in range(len(picture)):
    for x in range(len(picture[y])):
        paint_pixel(x-x_s, y-y_s, char_to_col[picture[y][x]])
